# 📘 Guia de Instalação pelo CMD (Prompt de Comando)

Este guia vai te ensinar a instalar e rodar o site usando o **CMD** (Prompt de Comando) do Windows.

---

## 🎯 Passo 1: Abrir o CMD

### Opção A: Pelo Menu Iniciar
1. Pressione a tecla **Windows** no seu teclado
2. Digite: `cmd`
3. Clique em **"Prompt de Comando"** ou pressione Enter

### Opção B: Pelo Explorador de Arquivos
1. Abra o Explorador de Arquivos
2. Navegue até a pasta do projeto:
   ```
   C:\Users\Nyl Campos\Desktop\MeuPortfolio\Hecol\siteprincipal HECOL\controle-certos-site-38617-37227-41818-main
   ```
3. Clique na barra de endereço (onde mostra o caminho)
4. Digite: `cmd` e pressione Enter

### Opção C: Direto na Pasta
1. Abra a pasta do projeto no Explorador
2. Clique com o botão direito em qualquer lugar vazio
3. Selecione **"Abrir janela do PowerShell aqui"** ou **"Abrir no Terminal"**
   - Se não aparecer, segure **Shift** e clique com botão direito, então escolha **"Abrir janela do PowerShell aqui"**

---

## 📍 Passo 2: Navegar até a Pasta do Projeto

No CMD, você precisa estar na pasta correta. Use o comando `cd`:

```cmd
cd "C:\Users\Nyl Campos\Desktop\MeuPortfolio\Hecol\siteprincipal HECOL\controle-certos-site-38617-37227-41818-main"
```

**Dica:** Se você já abriu o CMD pela pasta (Opção B ou C acima), você já está no lugar certo!

**Para verificar onde você está:**
```cmd
cd
```

**Para ver o conteúdo da pasta:**
```cmd
dir
```

---

## ✅ Passo 3: Verificar se Node.js está Instalado

Digite:
```cmd
node --version
```

**Se aparecer um número (ex: v18.17.0):**
✅ Node.js está instalado! Continue para o próximo passo.

**Se aparecer erro "não é reconhecido":**
❌ Node.js não está instalado. Você precisa:
1. Baixar de: https://nodejs.org/
2. Instalar (sempre clique "Next" durante a instalação)
3. Reiniciar o CMD
4. Tentar novamente: `node --version`

---

## 📦 Passo 4: Instalar as Dependências

Este é o passo mais importante! Execute:

```cmd
npm install
```

**O que vai acontecer:**
- O npm vai baixar todas as bibliotecas necessárias
- Pode levar de 2 a 5 minutos
- Você verá muitas linhas de texto rolando
- No final, deve aparecer algo como: `added 500 packages`

**⚠️ IMPORTANTE:**
- Não feche o CMD durante a instalação
- Se der erro, anote a mensagem e me avise
- Se demorar muito, é normal na primeira vez

**Exemplo do que você verá:**
```
npm WARN deprecated ...
added 500 packages, and audited 501 packages in 2m
found 0 vulnerabilities
```

---

## 📝 Passo 5: Criar Arquivo de Configuração

Crie o arquivo `.env.local` (necessário para o site funcionar):

```cmd
copy .env.example .env.local
```

**Se aparecer "1 arquivo(s) copiado(s)":**
✅ Arquivo criado com sucesso!

**Se aparecer erro "não foi possível encontrar":**
Não tem problema! O site funciona sem ele. Continue para o próximo passo.

---

## 🚀 Passo 6: Rodar o Site

Agora é só iniciar o servidor:

```cmd
npm run dev
```

**O que vai acontecer:**
- O Vite vai compilar o projeto
- Você verá algo como:
  ```
  VITE v5.4.19  ready in 500 ms

  ➜  Local:   http://localhost:8080/
  ➜  Network: use --host to expose
  ```

**✅ SUCESSO!** O site está rodando!

---

## 🌐 Passo 7: Abrir no Navegador

1. Abra seu navegador (Chrome, Edge, Firefox, etc.)
2. Digite na barra de endereço:
   ```
   http://localhost:8080
   ```
3. Pressione Enter

**🎉 Pronto!** Você deve ver o site da Hecol!

---

## 📋 Comandos Úteis do CMD

### Ver onde você está:
```cmd
cd
```

### Listar arquivos da pasta:
```cmd
dir
```

### Navegar para uma pasta:
```cmd
cd nome-da-pasta
```

### Voltar uma pasta:
```cmd
cd ..
```

### Limpar a tela:
```cmd
cls
```

### Parar o servidor (quando estiver rodando):
```
Pressione: Ctrl + C
```

---

## 🔄 Para Rodar Novamente (Próximas Vezes)

Depois da primeira instalação, você só precisa:

1. Abrir o CMD na pasta do projeto
2. Executar:
   ```cmd
   npm run dev
   ```
3. Abrir: http://localhost:8080

**Não precisa rodar `npm install` de novo!** (Só se adicionar novas dependências)

---

## 🛑 Como Parar o Servidor

Quando o servidor estiver rodando, você verá o CMD "travado" (não aceita novos comandos).

**Para parar:**
1. Clique no CMD
2. Pressione: **Ctrl + C**
3. Digite `S` e Enter (se perguntar)

Agora você pode fechar o CMD ou rodar outro comando.

---

## ❌ Solução de Problemas Comuns

### Erro: "npm não é reconhecido"
**Solução:**
- Node.js não está instalado ou não está no PATH
- Reinstale Node.js de https://nodejs.org/
- Reinicie o CMD após instalar

### Erro: "Cannot find module"
**Solução:**
```cmd
npm install
```

### Erro: "Port 8080 is already in use"
**Solução:**
- Outro programa está usando a porta 8080
- Feche outros programas ou mude a porta no `vite.config.ts`

### Site não abre no navegador
**Solução:**
- Verifique se o servidor está rodando (veja o CMD)
- Tente: http://127.0.0.1:8080
- Verifique se não há firewall bloqueando

### Erro ao copiar .env.example
**Solução:**
- Não tem problema! O site funciona sem ele
- Você pode criar manualmente depois se precisar

---

## 📚 Resumo dos Comandos Principais

```cmd
# 1. Ir para a pasta do projeto
cd "C:\Users\Nyl Campos\Desktop\MeuPortfolio\Hecol\siteprincipal HECOL\controle-certos-site-38617-37227-41818-main"

# 2. Verificar Node.js
node --version

# 3. Instalar dependências (só na primeira vez)
npm install

# 4. Criar arquivo de configuração (opcional)
copy .env.example .env.local

# 5. Rodar o site
npm run dev

# 6. Abrir no navegador: http://localhost:8080
```

---

## 🎓 Dicas para Iniciantes

1. **Sempre leia as mensagens de erro** - Elas geralmente dizem o que está errado
2. **Copie e cole os comandos** - Evita erros de digitação
3. **Mantenha o CMD aberto** - Enquanto o servidor estiver rodando
4. **Use Ctrl+C para parar** - Quando precisar parar o servidor
5. **Não tenha medo de errar** - Erros são normais e fazem parte do aprendizado!

---

## 🆘 Precisa de Ajuda?

Se algo não funcionar:
1. Anote a mensagem de erro completa
2. Verifique se seguiu todos os passos
3. Tente as soluções acima
4. Se ainda não funcionar, me mostre a mensagem de erro

---

**Boa sorte! 🚀**
