# Script de Instalação - Hecol Saúde Ambiental
# Execute este script no PowerShell para configurar o ambiente

Write-Host "🚀 Configurando ambiente de desenvolvimento..." -ForegroundColor Cyan
Write-Host ""

# Verificar Node.js
Write-Host "📦 Verificando Node.js..." -ForegroundColor Yellow
try {
    $nodeVersion = node --version
    Write-Host "✅ Node.js instalado: $nodeVersion" -ForegroundColor Green
} catch {
    Write-Host "❌ Node.js não encontrado!" -ForegroundColor Red
    Write-Host "Por favor, instale Node.js 18+ de https://nodejs.org/" -ForegroundColor Yellow
    exit 1
}

# Verificar npm
Write-Host "📦 Verificando npm..." -ForegroundColor Yellow
try {
    $npmVersion = npm --version
    Write-Host "✅ npm instalado: $npmVersion" -ForegroundColor Green
} catch {
    Write-Host "❌ npm não encontrado!" -ForegroundColor Red
    exit 1
}

Write-Host ""

# Instalar dependências
Write-Host "📥 Instalando dependências..." -ForegroundColor Yellow
Write-Host "Isso pode levar alguns minutos..." -ForegroundColor Gray
npm install

if ($LASTEXITCODE -ne 0) {
    Write-Host "❌ Erro ao instalar dependências!" -ForegroundColor Red
    exit 1
}

Write-Host "✅ Dependências instaladas com sucesso!" -ForegroundColor Green
Write-Host ""

# Criar .env.local se não existir
if (-not (Test-Path .env.local)) {
    Write-Host "📝 Criando arquivo .env.local..." -ForegroundColor Yellow
    if (Test-Path .env.example) {
        Copy-Item .env.example .env.local
        Write-Host "✅ Arquivo .env.local criado a partir de .env.example" -ForegroundColor Green
        Write-Host "⚠️  IMPORTANTE: Edite .env.local e configure suas variáveis de ambiente" -ForegroundColor Yellow
    } else {
        Write-Host "⚠️  Arquivo .env.example não encontrado. Criando .env.local básico..." -ForegroundColor Yellow
        @"
# Variáveis de Ambiente
VITE_SUPABASE_URL=
VITE_SUPABASE_PUBLISHABLE_KEY=
"@ | Out-File -FilePath .env.local -Encoding utf8
        Write-Host "✅ Arquivo .env.local criado" -ForegroundColor Green
    }
} else {
    Write-Host "ℹ️  Arquivo .env.local já existe" -ForegroundColor Cyan
}

Write-Host ""
Write-Host "🎉 Instalação concluída!" -ForegroundColor Green
Write-Host ""
Write-Host "Próximos passos:" -ForegroundColor Cyan
Write-Host "1. Edite o arquivo .env.local se necessário" -ForegroundColor White
Write-Host "2. Execute: npm run dev" -ForegroundColor White
Write-Host "3. Acesse: http://localhost:8080" -ForegroundColor White
Write-Host ""
