#!/bin/bash
# Script de Instalação - Hecol Saúde Ambiental
# Execute este script no terminal para configurar o ambiente

echo "🚀 Configurando ambiente de desenvolvimento..."
echo ""

# Verificar Node.js
echo "📦 Verificando Node.js..."
if command -v node &> /dev/null; then
    NODE_VERSION=$(node --version)
    echo "✅ Node.js instalado: $NODE_VERSION"
else
    echo "❌ Node.js não encontrado!"
    echo "Por favor, instale Node.js 18+ de https://nodejs.org/"
    exit 1
fi

# Verificar npm
echo "📦 Verificando npm..."
if command -v npm &> /dev/null; then
    NPM_VERSION=$(npm --version)
    echo "✅ npm instalado: $NPM_VERSION"
else
    echo "❌ npm não encontrado!"
    exit 1
fi

echo ""

# Instalar dependências
echo "📥 Instalando dependências..."
echo "Isso pode levar alguns minutos..."
npm install

if [ $? -ne 0 ]; then
    echo "❌ Erro ao instalar dependências!"
    exit 1
fi

echo "✅ Dependências instaladas com sucesso!"
echo ""

# Criar .env.local se não existir
if [ ! -f .env.local ]; then
    echo "📝 Criando arquivo .env.local..."
    if [ -f .env.example ]; then
        cp .env.example .env.local
        echo "✅ Arquivo .env.local criado a partir de .env.example"
        echo "⚠️  IMPORTANTE: Edite .env.local e configure suas variáveis de ambiente"
    else
        echo "⚠️  Arquivo .env.example não encontrado. Criando .env.local básico..."
        cat > .env.local << EOF
# Variáveis de Ambiente
VITE_SUPABASE_URL=
VITE_SUPABASE_PUBLISHABLE_KEY=
EOF
        echo "✅ Arquivo .env.local criado"
    fi
else
    echo "ℹ️  Arquivo .env.local já existe"
fi

echo ""
echo "🎉 Instalação concluída!"
echo ""
echo "Próximos passos:"
echo "1. Edite o arquivo .env.local se necessário"
echo "2. Execute: npm run dev"
echo "3. Acesse: http://localhost:8080"
echo ""
