import { useEffect, useState } from "react";
import { loadManifest, getAssetsBySection, getAssetPath, type ManifestRow } from "@/lib/contentLoader";

const Gallery = () => {
  const [galleryItems, setGalleryItems] = useState<ManifestRow[]>([]);

  useEffect(() => {
    loadManifest().then(manifest => {
      const items = getAssetsBySection(manifest, 'gallery');
      setGalleryItems(items);
    });
  }, []);

  if (galleryItems.length === 0) return null;

  return (
    <section className="bg-gradient-to-b from-muted/20 to-background border-t-2 border-brand-red-divider" id="galeria" aria-label="Galeria de Trabalhos">
      <div className="container mx-auto px-4 py-24">
        <div className="text-center mb-16 animate-fade-in">
          <h2 className="text-4xl md:text-5xl font-bold mb-4">
            Nossa Galeria
          </h2>
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            Veja alguns dos nossos trabalhos realizados
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          {galleryItems.map((item, index) => (
            <div
              key={`${item.filename}-${index}`}
              className="group relative overflow-hidden rounded-xl shadow-lg hover-scale transition-all duration-300"
            >
              <img
                src={getAssetPath('gallery', item.filename)}
                alt={item.alt_pt}
                className="w-full h-80 object-cover transition-transform duration-300 group-hover:scale-110"
                loading="lazy"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                <div className="absolute bottom-0 left-0 right-0 p-6">
                  <h3 className="text-white font-semibold text-lg">
                    {item.title_pt}
                  </h3>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default Gallery;
