export const translations = {
  'pt-BR': {
    nav: {
      quemSomos: 'Sobre Nós',
      servicos: 'Serviços',
      galeria: 'Galeria',
      eventos: 'Eventos',
      contato: 'Contato',
      trabalheConosco: 'Trabalhe Conosco',
    },
    promo: {
      text: 'Atendimento 24h • Orçamentos em até 2h',
    },
    hero: {
      title: 'Soluções Completas em Saúde Ambiental',
      subtitle: 'Proteção profissional para ambientes residenciais, comerciais e industriais com excelência e responsabilidade.',
      cta: 'Pedir Orçamento',
    },
    clients: {
      title: 'Nossos Clientes',
      subtitle: 'Empresas que confiam em nossos serviços',
    },
    cookies: {
      // Banner
      bannerTitle: 'Sua Privacidade',
      bannerDescription: 'Usamos cookies para melhorar sua experiência, medir uso e oferecer conteúdo relevante. Você decide o que permitir.',
      acceptAll: 'Aceitar Todos',
      rejectAll: 'Recusar Todos',
      customizeButton: 'Personalizar',
      
      // Modal
      modalTitle: 'Gerenciar Preferências de Cookies',
      modalDescription: 'Você pode escolher quais tipos de cookies permitir. Suas escolhas serão salvas por 12 meses.',
      
      // Categorias
      necessary: 'Necessários',
      necessaryDesc: 'Cookies essenciais para segurança, sessão e funcionamento básico do site. Não podem ser desativados.',
      necessaryExamples: 'Ex.: Autenticação, prevenção de fraude, segurança',
      necessaryDuration: 'Sessão ou até 24h',
      
      preferences: 'Preferências',
      preferencesDesc: 'Permitem lembrar suas escolhas, como idioma preferido e configurações personalizadas.',
      preferencesExamples: 'Ex.: Idioma, tema, filtros, layout',
      preferencesDuration: '6–12 meses',
      
      analytics: 'Métricas e Analytics',
      analyticsDesc: 'Coletam estatísticas de uso de forma anônima e agregada para melhorar o site.',
      analyticsExamples: 'Ex.: Google Analytics, páginas visitadas, tempo de permanência',
      analyticsDuration: 'Até 13 meses',
      
      marketing: 'Marketing e Publicidade',
      marketingDesc: 'Utilizados para exibir anúncios personalizados e medir campanhas publicitárias.',
      marketingExamples: 'Ex.: Meta Pixel, Google Ads, remarketing',
      marketingDuration: 'Conforme fornecedor (geralmente 90 dias)',
      
      // Labels
      alwaysActive: 'Sempre ativo',
      savePreferences: 'Salvar Preferências',
      manageCookies: 'Gerenciar Cookies',
      
      // Política de Cookies (página dedicada)
      policyTitle: 'Política de Cookies',
      policySubtitle: 'Transparência sobre como usamos cookies e tecnologias similares',
      
      introTitle: 'Introdução',
      introText: 'Este site utiliza cookies e tecnologias similares para garantir o funcionamento adequado, personalizar sua experiência e analisar nosso tráfego. Respeitamos sua privacidade e seguimos as diretrizes da LGPD e GDPR.',
      
      whatAreTitle: 'O que são cookies?',
      whatAreText: 'Cookies são pequenos arquivos de texto armazenados no seu dispositivo quando você visita um site. Eles permitem que o site reconheça seu dispositivo e lembre de informações sobre sua visita.',
      
      typesTitle: 'Tipos de cookies que usamos',
      typesIntro: 'Classificamos nossos cookies em quatro categorias principais:',
      examplesLabel: 'Exemplos:',
      durationLabel: 'Duração típica:',
      sessionDuration: 'Sessão',
      
      tableTitle: 'Detalhamento dos cookies',
      tableCaption: 'Lista completa dos cookies utilizados neste site',
      tableColName: 'Nome',
      tableColCategory: 'Categoria',
      tableColPurpose: 'Finalidade',
      tableColDuration: 'Duração',
      tableConsentPurpose: 'Registra suas preferências de consentimento',
      tableSessionPurpose: 'Mantém sessão de navegação segura',
      tableLangPurpose: 'Armazena idioma preferido',
      
      manageTitle: 'Como gerenciar suas preferências',
      manageText: 'Você pode alterar suas preferências de cookies a qualquer momento clicando no botão abaixo. Se você retirar o consentimento, algumas funcionalidades podem ser limitadas.',
      
      browserTitle: 'Controles do navegador',
      browserText: 'A maioria dos navegadores aceita cookies automaticamente, mas você pode configurá-los para recusar ou deletar cookies. Consulte a ajuda do seu navegador para mais informações. Note que desabilitar cookies pode afetar a funcionalidade do site.',
      
      dntTitle: 'Do Not Track e Global Privacy Control',
      dntText: 'Respeitamos sinais de Do Not Track (DNT) e Global Privacy Control (GPC). Se esses recursos estiverem ativos em seu navegador, consideraremos isso como uma escolha de recusar cookies não essenciais.',
      
      updatesTitle: 'Atualizações desta política',
      updatesText: 'Podemos atualizar esta Política de Cookies periodicamente. Mudanças significativas serão comunicadas através de um aviso no site e solicitaremos novo consentimento quando necessário.',
      lastUpdate: 'Última atualização:',
      
      contactTitle: 'Dúvidas sobre cookies?',
      contactText: 'Se você tiver dúvidas sobre como usamos cookies ou desejar exercer seus direitos de privacidade, entre em contato conosco:',
    },
    location: {
      title: 'Nossa Localização',
      address: 'Rua Exemplo, 123 – Centro – Cidade/PE – CEP 50000-000',
      route: 'Traçar Rota',
      contact: 'Falar com Atendimento',
    },
    footer: {
      company: 'Empresa',
      services: 'Serviços',
      contact: 'Contato',
      address: 'Endereço',
      phone: 'Telefone',
      email: 'E-mail',
      rights: 'Todos os direitos reservados.',
    },
  },
  'en': {
    nav: {
      quemSomos: 'About Us',
      servicos: 'Services',
      galeria: 'Gallery',
      eventos: 'Events',
      contato: 'Contact',
      trabalheConosco: 'Work With Us',
    },
    promo: {
      text: '24/7 Service • Quotes within 2 hours',
    },
    hero: {
      title: 'Complete Environmental Health Solutions',
      subtitle: 'Professional protection for residential, commercial and industrial environments with excellence and responsibility.',
      cta: 'Request Quote',
    },
    clients: {
      title: 'Our Clients',
      subtitle: 'Companies that trust our services',
    },
    cookies: {
      bannerTitle: 'Your Privacy',
      bannerDescription: 'We use cookies to improve your experience, measure usage and provide relevant content. You decide what to allow.',
      acceptAll: 'Accept All',
      rejectAll: 'Reject All',
      customizeButton: 'Customize',
      modalTitle: 'Manage Cookie Preferences',
      modalDescription: 'You can choose which types of cookies to allow. Your choices will be saved for 12 months.',
      necessary: 'Necessary',
      necessaryDesc: 'Essential cookies for security, session and basic site functionality. Cannot be disabled.',
      necessaryExamples: 'E.g.: Authentication, fraud prevention, security',
      necessaryDuration: 'Session or up to 24h',
      preferences: 'Preferences',
      preferencesDesc: 'Allow remembering your choices, such as preferred language and custom settings.',
      preferencesExamples: 'E.g.: Language, theme, filters, layout',
      preferencesDuration: '6–12 months',
      analytics: 'Metrics and Analytics',
      analyticsDesc: 'Collect anonymous and aggregated usage statistics to improve the site.',
      analyticsExamples: 'E.g.: Google Analytics, visited pages, dwell time',
      analyticsDuration: 'Up to 13 months',
      marketing: 'Marketing and Advertising',
      marketingDesc: 'Used to display personalized ads and measure advertising campaigns.',
      marketingExamples: 'E.g.: Meta Pixel, Google Ads, remarketing',
      marketingDuration: 'As per provider (typically 90 days)',
      alwaysActive: 'Always active',
      savePreferences: 'Save Preferences',
      manageCookies: 'Manage Cookies',
      policyTitle: 'Cookie Policy',
      policySubtitle: 'Transparency about how we use cookies and similar technologies',
      introTitle: 'Introduction',
      introText: 'This site uses cookies and similar technologies to ensure proper operation, personalize your experience and analyze our traffic. We respect your privacy and follow LGPD and GDPR guidelines.',
      whatAreTitle: 'What are cookies?',
      whatAreText: 'Cookies are small text files stored on your device when you visit a website. They allow the site to recognize your device and remember information about your visit.',
      typesTitle: 'Types of cookies we use',
      typesIntro: 'We classify our cookies into four main categories:',
      examplesLabel: 'Examples:',
      durationLabel: 'Typical duration:',
      sessionDuration: 'Session',
      tableTitle: 'Cookie breakdown',
      tableCaption: 'Complete list of cookies used on this site',
      tableColName: 'Name',
      tableColCategory: 'Category',
      tableColPurpose: 'Purpose',
      tableColDuration: 'Duration',
      tableConsentPurpose: 'Records your consent preferences',
      tableSessionPurpose: 'Maintains secure browsing session',
      tableLangPurpose: 'Stores preferred language',
      manageTitle: 'How to manage your preferences',
      manageText: 'You can change your cookie preferences at any time by clicking the button below. If you withdraw consent, some features may be limited.',
      browserTitle: 'Browser controls',
      browserText: 'Most browsers accept cookies automatically, but you can configure them to refuse or delete cookies. Consult your browser help for more information. Note that disabling cookies may affect site functionality.',
      dntTitle: 'Do Not Track and Global Privacy Control',
      dntText: 'We respect Do Not Track (DNT) and Global Privacy Control (GPC) signals. If these features are active in your browser, we will consider this as a choice to refuse non-essential cookies.',
      updatesTitle: 'Updates to this policy',
      updatesText: 'We may update this Cookie Policy periodically. Significant changes will be communicated through a notice on the site and we will request new consent when necessary.',
      lastUpdate: 'Last update:',
      contactTitle: 'Questions about cookies?',
      contactText: 'If you have questions about how we use cookies or wish to exercise your privacy rights, contact us:',
    },
    location: {
      title: 'Our Location',
      address: 'Example Street, 123 – Downtown – City/PE – ZIP 50000-000',
      route: 'Get Directions',
      contact: 'Contact Support',
    },
    footer: {
      company: 'Company',
      services: 'Services',
      contact: 'Contact',
      address: 'Address',
      phone: 'Phone',
      email: 'Email',
      rights: 'All rights reserved.',
    },
  },
  'es': {
    nav: {
      quemSomos: 'Quiénes Somos',
      servicos: 'Servicios',
      galeria: 'Galería',
      eventos: 'Eventos',
      contato: 'Contacto',
      trabalheConosco: 'Trabaja Con Nosotros',
    },
    promo: {
      text: 'Atención 24h • Presupuestos en hasta 2h',
    },
    hero: {
      title: 'Soluciones Completas en Salud Ambiental',
      subtitle: 'Protección profesional para ambientes residenciales, comerciales e industriales con excelencia y responsabilidad.',
      cta: 'Solicitar Presupuesto',
    },
    clients: {
      title: 'Nuestros Clientes',
      subtitle: 'Empresas que confían en nuestros servicios',
    },
    cookies: {
      bannerTitle: 'Su Privacidad',
      bannerDescription: 'Usamos cookies para mejorar su experiencia, medir el uso y ofrecer contenido relevante. Usted decide qué permitir.',
      acceptAll: 'Aceptar Todos',
      rejectAll: 'Rechazar Todos',
      customizeButton: 'Personalizar',
      modalTitle: 'Administrar Preferencias de Cookies',
      modalDescription: 'Puede elegir qué tipos de cookies permitir. Sus elecciones se guardarán durante 12 meses.',
      necessary: 'Necesarias',
      necessaryDesc: 'Cookies esenciales para seguridad, sesión y funcionamiento básico del sitio. No se pueden desactivar.',
      necessaryExamples: 'Ej.: Autenticación, prevención de fraude, seguridad',
      necessaryDuration: 'Sesión o hasta 24h',
      preferences: 'Preferencias',
      preferencesDesc: 'Permiten recordar sus elecciones, como idioma preferido y configuraciones personalizadas.',
      preferencesExamples: 'Ej.: Idioma, tema, filtros, diseño',
      preferencesDuration: '6–12 meses',
      analytics: 'Métricas y Analytics',
      analyticsDesc: 'Recopilan estadísticas de uso de forma anónima y agregada para mejorar el sitio.',
      analyticsExamples: 'Ej.: Google Analytics, páginas visitadas, tiempo de permanencia',
      analyticsDuration: 'Hasta 13 meses',
      marketing: 'Marketing y Publicidad',
      marketingDesc: 'Utilizadas para mostrar anuncios personalizados y medir campañas publicitarias.',
      marketingExamples: 'Ej.: Meta Pixel, Google Ads, remarketing',
      marketingDuration: 'Según proveedor (generalmente 90 días)',
      alwaysActive: 'Siempre activo',
      savePreferences: 'Guardar Preferencias',
      manageCookies: 'Administrar Cookies',
      policyTitle: 'Política de Cookies',
      policySubtitle: 'Transparencia sobre cómo usamos cookies y tecnologías similares',
      introTitle: 'Introducción',
      introText: 'Este sitio utiliza cookies y tecnologías similares para garantizar el funcionamiento adecuado, personalizar su experiencia y analizar nuestro tráfico. Respetamos su privacidad y seguimos las directrices de LGPD y GDPR.',
      whatAreTitle: '¿Qué son las cookies?',
      whatAreText: 'Las cookies son pequeños archivos de texto almacenados en su dispositivo cuando visita un sitio web. Permiten que el sitio reconozca su dispositivo y recuerde información sobre su visita.',
      typesTitle: 'Tipos de cookies que usamos',
      typesIntro: 'Clasificamos nuestras cookies en cuatro categorías principales:',
      examplesLabel: 'Ejemplos:',
      durationLabel: 'Duración típica:',
      sessionDuration: 'Sesión',
      tableTitle: 'Desglose de cookies',
      tableCaption: 'Lista completa de cookies utilizadas en este sitio',
      tableColName: 'Nombre',
      tableColCategory: 'Categoría',
      tableColPurpose: 'Finalidad',
      tableColDuration: 'Duración',
      tableConsentPurpose: 'Registra sus preferencias de consentimiento',
      tableSessionPurpose: 'Mantiene sesión de navegación segura',
      tableLangPurpose: 'Almacena idioma preferido',
      manageTitle: 'Cómo administrar sus preferencias',
      manageText: 'Puede cambiar sus preferencias de cookies en cualquier momento haciendo clic en el botón a continuación. Si retira el consentimiento, algunas funcionalidades pueden ser limitadas.',
      browserTitle: 'Controles del navegador',
      browserText: 'La mayoría de los navegadores aceptan cookies automáticamente, pero puede configurarlos para rechazar o eliminar cookies. Consulte la ayuda de su navegador para más información. Tenga en cuenta que deshabilitar las cookies puede afectar la funcionalidad del sitio.',
      dntTitle: 'Do Not Track y Global Privacy Control',
      dntText: 'Respetamos las señales de Do Not Track (DNT) y Global Privacy Control (GPC). Si estas funciones están activas en su navegador, lo consideraremos como una elección de rechazar cookies no esenciales.',
      updatesTitle: 'Actualizaciones de esta política',
      updatesText: 'Podemos actualizar esta Política de Cookies periódicamente. Los cambios significativos se comunicarán mediante un aviso en el sitio y solicitaremos nuevo consentimiento cuando sea necesario.',
      lastUpdate: 'Última actualización:',
      contactTitle: '¿Preguntas sobre cookies?',
      contactText: 'Si tiene preguntas sobre cómo usamos cookies o desea ejercer sus derechos de privacidad, contáctenos:',
    },
    location: {
      title: 'Nuestra Ubicación',
      address: 'Calle Ejemplo, 123 – Centro – Ciudad/PE – CEP 50000-000',
      route: 'Cómo llegar',
      contact: 'Contactar Soporte',
    },
    footer: {
      company: 'Empresa',
      services: 'Servicios',
      contact: 'Contacto',
      address: 'Dirección',
      phone: 'Teléfono',
      email: 'Correo',
      rights: 'Todos los derechos reservados.',
    },
  },
} as const;

export type Locale = keyof typeof translations;
export type TranslationKeys = typeof translations['pt-BR'];
