import Header from "@/components/layout/Header";
import Footer from "@/components/layout/Footer";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { ShieldCheck, UserCheck, Lock, FileKey } from "lucide-react";

const LGPD = () => {
  return (
    <div className="min-h-screen">
      <Header />
      <main className="pt-20">
        <section className="py-20 bg-gradient-to-br from-secondary to-secondary/80 text-white">
          <div className="container mx-auto px-4 text-center">
            <ShieldCheck className="w-16 h-16 mx-auto mb-4" />
            <h1 className="mb-6">LGPD - Proteção de Dados</h1>
            <p className="text-xl text-gray-200 max-w-3xl mx-auto">
              Nosso compromisso com a Lei Geral de Proteção de Dados Pessoais
            </p>
          </div>
        </section>

        {/* Compromisso */}
        <section className="py-16 bg-background">
          <div className="container mx-auto px-4 max-w-4xl">
            <Card className="p-8 mb-12">
              <h2 className="text-2xl font-bold mb-4">Nossa Conformidade com a LGPD</h2>
              <p className="text-muted-foreground mb-6">
                A Saúde Ambiental está em total conformidade com a Lei nº 13.709/2018 (Lei Geral de
                Proteção de Dados Pessoais - LGPD). Proteger seus dados pessoais é uma prioridade
                para nós.
              </p>

              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div className="flex items-start space-x-3">
                  <UserCheck className="w-8 h-8 text-primary flex-shrink-0 mt-1" />
                  <div>
                    <h3 className="font-bold mb-2">Consentimento</h3>
                    <p className="text-sm text-muted-foreground">
                      Solicitamos autorização explícita antes de coletar e processar seus dados
                    </p>
                  </div>
                </div>
                <div className="flex items-start space-x-3">
                  <Lock className="w-8 h-8 text-primary flex-shrink-0 mt-1" />
                  <div>
                    <h3 className="font-bold mb-2">Segurança</h3>
                    <p className="text-sm text-muted-foreground">
                      Medidas técnicas e administrativas para proteger suas informações
                    </p>
                  </div>
                </div>
                <div className="flex items-start space-x-3">
                  <FileKey className="w-8 h-8 text-primary flex-shrink-0 mt-1" />
                  <div>
                    <h3 className="font-bold mb-2">Transparência</h3>
                    <p className="text-sm text-muted-foreground">
                      Informações claras sobre como usamos seus dados
                    </p>
                  </div>
                </div>
                <div className="flex items-start space-x-3">
                  <ShieldCheck className="w-8 h-8 text-primary flex-shrink-0 mt-1" />
                  <div>
                    <h3 className="font-bold mb-2">Direitos Garantidos</h3>
                    <p className="text-sm text-muted-foreground">
                      Você tem controle total sobre suas informações pessoais
                    </p>
                  </div>
                </div>
              </div>
            </Card>
          </div>
        </section>

        {/* Seus Direitos */}
        <section className="py-16 bg-muted">
          <div className="container mx-auto px-4 max-w-4xl">
            <h2 className="text-3xl font-bold mb-8 text-center">Seus Direitos sob a LGPD</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              {[
                {
                  title: "Acesso",
                  description: "Confirmar e acessar seus dados pessoais que mantemos",
                },
                {
                  title: "Correção",
                  description: "Solicitar correção de dados incompletos ou desatualizados",
                },
                {
                  title: "Anonimização",
                  description: "Pedir anonimização ou bloqueio de dados desnecessários",
                },
                {
                  title: "Eliminação",
                  description: "Solicitar exclusão de dados tratados com seu consentimento",
                },
                {
                  title: "Portabilidade",
                  description: "Receber seus dados em formato estruturado",
                },
                {
                  title: "Revogação",
                  description: "Revogar consentimento a qualquer momento",
                },
              ].map((right, index) => (
                <Card key={index} className="p-6">
                  <h3 className="text-xl font-bold mb-2">{right.title}</h3>
                  <p className="text-sm text-muted-foreground">{right.description}</p>
                </Card>
              ))}
            </div>
          </div>
        </section>

        {/* Como Exercer Direitos */}
        <section className="py-16 bg-background">
          <div className="container mx-auto px-4 max-w-4xl">
            <Card className="p-8">
              <h2 className="text-2xl font-bold mb-6">Como Exercer Seus Direitos</h2>
              <p className="text-muted-foreground mb-6">
                Para exercer qualquer dos seus direitos ou esclarecer dúvidas sobre o tratamento
                dos seus dados pessoais, você pode entrar em contato conosco através dos seguintes
                canais:
              </p>

              <div className="space-y-4 mb-8">
                <div className="flex items-start space-x-3">
                  <div className="w-8 h-8 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <span className="text-primary font-bold">1</span>
                  </div>
                  <div>
                    <h3 className="font-bold mb-1">E-mail Dedicado</h3>
                    <p className="text-sm text-muted-foreground">
                      <a
                        href="mailto:privacidade@saudeambiental.com.br"
                        className="text-primary hover:underline"
                      >
                        privacidade@saudeambiental.com.br
                      </a>
                    </p>
                  </div>
                </div>

                <div className="flex items-start space-x-3">
                  <div className="w-8 h-8 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <span className="text-primary font-bold">2</span>
                  </div>
                  <div>
                    <h3 className="font-bold mb-1">Telefone</h3>
                    <p className="text-sm text-muted-foreground">(81) 3000-1234</p>
                  </div>
                </div>

                <div className="flex items-start space-x-3">
                  <div className="w-8 h-8 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <span className="text-primary font-bold">3</span>
                  </div>
                  <div>
                    <h3 className="font-bold mb-1">Correspondência</h3>
                    <p className="text-sm text-muted-foreground">
                      Av. Principal, 1234 - Centro
                      <br />
                      Recife, PE - CEP 50000-000
                      <br />
                      Att: Encarregado de Dados
                    </p>
                  </div>
                </div>
              </div>

              <div className="bg-muted p-4 rounded-lg">
                <p className="text-sm text-muted-foreground">
                  <strong>Prazo de Resposta:</strong> Responderemos suas solicitações em até 15
                  (quinze) dias úteis, conforme estabelecido pela LGPD.
                </p>
              </div>
            </Card>
          </div>
        </section>

        {/* CTA */}
        <section className="py-16 bg-primary text-primary-foreground">
          <div className="container mx-auto px-4 text-center">
            <h2 className="mb-4 text-white">Ainda tem dúvidas sobre LGPD?</h2>
            <p className="text-xl text-white/90 mb-8 max-w-2xl mx-auto">
              Nossa equipe está pronta para esclarecer qualquer questão sobre proteção de dados.
            </p>
            <Button variant="outline" size="lg" asChild className="bg-white text-primary hover:bg-gray-100">
              <a href="mailto:privacidade@saudeambiental.com.br">
                Falar com Encarregado de Dados
              </a>
            </Button>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default LGPD;
