import Header from "@/components/layout/Header";
import Footer from "@/components/layout/Footer";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Cookie, Settings } from "lucide-react";
import { useLanguage } from "@/lib/i18n/LanguageContext";
import { useCookieConsent } from "@/hooks/useCookieConsent";
import {
  Table,
  TableBody,
  TableCaption,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";

const PoliticaCookies = () => {
  const { t } = useLanguage();
  const { openPreferences } = useCookieConsent();

  return (
    <div className="min-h-screen flex flex-col">
      <Header />
      
      <main className="flex-1">
        {/* Hero Section */}
        <section className="bg-gradient-to-br from-primary/5 to-primary/10 py-16 lg:py-20">
          <div className="container mx-auto px-4">
            <div className="max-w-4xl mx-auto text-center">
              <div className="inline-flex items-center justify-center w-16 h-16 rounded-full bg-brand-red/10 mb-6">
                <Cookie className="w-8 h-8 text-brand-red" />
              </div>
              <h1 className="text-4xl lg:text-5xl font-bold text-foreground mb-4">
                {t.cookies.policyTitle}
              </h1>
              <p className="text-lg text-muted-foreground">
                {t.cookies.policySubtitle}
              </p>
            </div>
          </div>
        </section>

        {/* Content */}
        <section className="py-16 lg:py-20">
          <div className="container mx-auto px-4">
            <Card className="max-w-5xl mx-auto p-8 lg:p-12 space-y-8">
              
              {/* Introdução */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  1. {t.cookies.introTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed">
                  {t.cookies.introText}
                </p>
              </div>

              {/* O que são cookies */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  2. {t.cookies.whatAreTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed">
                  {t.cookies.whatAreText}
                </p>
              </div>

              {/* Tipos de cookies */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  3. {t.cookies.typesTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed mb-4">
                  {t.cookies.typesIntro}
                </p>

                <div className="space-y-6">
                  <div className="border-l-4 border-brand-red pl-4">
                    <h3 className="text-lg font-semibold mb-2">{t.cookies.necessary}</h3>
                    <p className="text-sm text-muted-foreground mb-2">
                      {t.cookies.necessaryDesc}
                    </p>
                    <p className="text-xs text-muted-foreground italic">
                      <strong>{t.cookies.examplesLabel}</strong> {t.cookies.necessaryExamples}
                    </p>
                    <p className="text-xs text-muted-foreground mt-1">
                      <strong>{t.cookies.durationLabel}</strong> {t.cookies.necessaryDuration}
                    </p>
                  </div>

                  <div className="border-l-4 border-blue-500 pl-4">
                    <h3 className="text-lg font-semibold mb-2">{t.cookies.preferences}</h3>
                    <p className="text-sm text-muted-foreground mb-2">
                      {t.cookies.preferencesDesc}
                    </p>
                    <p className="text-xs text-muted-foreground italic">
                      <strong>{t.cookies.examplesLabel}</strong> {t.cookies.preferencesExamples}
                    </p>
                    <p className="text-xs text-muted-foreground mt-1">
                      <strong>{t.cookies.durationLabel}</strong> {t.cookies.preferencesDuration}
                    </p>
                  </div>

                  <div className="border-l-4 border-green-500 pl-4">
                    <h3 className="text-lg font-semibold mb-2">{t.cookies.analytics}</h3>
                    <p className="text-sm text-muted-foreground mb-2">
                      {t.cookies.analyticsDesc}
                    </p>
                    <p className="text-xs text-muted-foreground italic">
                      <strong>{t.cookies.examplesLabel}</strong> {t.cookies.analyticsExamples}
                    </p>
                    <p className="text-xs text-muted-foreground mt-1">
                      <strong>{t.cookies.durationLabel}</strong> {t.cookies.analyticsDuration}
                    </p>
                  </div>

                  <div className="border-l-4 border-purple-500 pl-4">
                    <h3 className="text-lg font-semibold mb-2">{t.cookies.marketing}</h3>
                    <p className="text-sm text-muted-foreground mb-2">
                      {t.cookies.marketingDesc}
                    </p>
                    <p className="text-xs text-muted-foreground italic">
                      <strong>{t.cookies.examplesLabel}</strong> {t.cookies.marketingExamples}
                    </p>
                    <p className="text-xs text-muted-foreground mt-1">
                      <strong>{t.cookies.durationLabel}</strong> {t.cookies.marketingDuration}
                    </p>
                  </div>
                </div>
              </div>

              {/* Tabela de cookies */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  4. {t.cookies.tableTitle}
                </h2>
                <div className="border rounded-lg overflow-hidden">
                  <Table>
                    <TableCaption>{t.cookies.tableCaption}</TableCaption>
                    <TableHeader>
                      <TableRow>
                        <TableHead className="font-semibold">{t.cookies.tableColName}</TableHead>
                        <TableHead className="font-semibold">{t.cookies.tableColCategory}</TableHead>
                        <TableHead className="font-semibold">{t.cookies.tableColPurpose}</TableHead>
                        <TableHead className="font-semibold">{t.cookies.tableColDuration}</TableHead>
                      </TableRow>
                    </TableHeader>
                    <TableBody>
                      <TableRow>
                        <TableCell className="font-mono text-xs">hecol_consent</TableCell>
                        <TableCell>{t.cookies.necessary}</TableCell>
                        <TableCell className="text-sm">{t.cookies.tableConsentPurpose}</TableCell>
                        <TableCell className="text-sm">12 meses</TableCell>
                      </TableRow>
                      <TableRow>
                        <TableCell className="font-mono text-xs">hecol_session</TableCell>
                        <TableCell>{t.cookies.necessary}</TableCell>
                        <TableCell className="text-sm">{t.cookies.tableSessionPurpose}</TableCell>
                        <TableCell className="text-sm">{t.cookies.sessionDuration}</TableCell>
                      </TableRow>
                      <TableRow>
                        <TableCell className="font-mono text-xs">hecol_lang</TableCell>
                        <TableCell>{t.cookies.preferences}</TableCell>
                        <TableCell className="text-sm">{t.cookies.tableLangPurpose}</TableCell>
                        <TableCell className="text-sm">12 meses</TableCell>
                      </TableRow>
                      <TableRow>
                        <TableCell className="font-mono text-xs">_ga, _gid</TableCell>
                        <TableCell>{t.cookies.analytics}</TableCell>
                        <TableCell className="text-sm">Google Analytics</TableCell>
                        <TableCell className="text-sm">13 meses / 24h</TableCell>
                      </TableRow>
                      <TableRow>
                        <TableCell className="font-mono text-xs">_fbp</TableCell>
                        <TableCell>{t.cookies.marketing}</TableCell>
                        <TableCell className="text-sm">Meta Pixel</TableCell>
                        <TableCell className="text-sm">90 dias</TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </div>
              </div>

              {/* Gerenciar preferências */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  5. {t.cookies.manageTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed">
                  {t.cookies.manageText}
                </p>
                <Button 
                  onClick={openPreferences}
                  className="bg-brand-red hover:bg-brand-red/90 text-white"
                  size="lg"
                >
                  <Settings className="w-4 h-4 mr-2" />
                  {t.cookies.manageCookies}
                </Button>
              </div>

              {/* Controles do navegador */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  6. {t.cookies.browserTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed">
                  {t.cookies.browserText}
                </p>
              </div>

              {/* Do Not Track */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  7. {t.cookies.dntTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed">
                  {t.cookies.dntText}
                </p>
              </div>

              {/* Atualizações */}
              <div className="space-y-4">
                <h2 className="text-2xl font-bold text-foreground">
                  8. {t.cookies.updatesTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed">
                  {t.cookies.updatesText}
                </p>
                <p className="text-sm text-muted-foreground">
                  <strong>{t.cookies.lastUpdate}</strong> Janeiro de 2025
                </p>
              </div>

              {/* Contato */}
              <div className="space-y-4 bg-muted/50 p-6 rounded-lg">
                <h2 className="text-2xl font-bold text-foreground">
                  9. {t.cookies.contactTitle}
                </h2>
                <p className="text-muted-foreground leading-relaxed">
                  {t.cookies.contactText}
                </p>
                <p className="text-sm">
                  <strong>E-mail:</strong>{" "}
                  <a href="mailto:privacidade@hecol.com.br" className="text-brand-red hover:underline">
                    privacidade@hecol.com.br
                  </a>
                </p>
              </div>

            </Card>
          </div>
        </section>
      </main>

      <Footer />
    </div>
  );
};

export default PoliticaCookies;
