import Header from "@/components/layout/Header";
import Footer from "@/components/layout/Footer";
import { Card } from "@/components/ui/card";
import { Shield } from "lucide-react";

const PoliticaPrivacidade = () => {
  return (
    <div className="min-h-screen">
      <Header />
      <main className="pt-20">
        <section className="py-20 bg-gradient-to-br from-secondary to-secondary/80 text-white">
          <div className="container mx-auto px-4 text-center">
            <Shield className="w-16 h-16 mx-auto mb-4" />
            <h1 className="mb-6">Política de Privacidade</h1>
            <p className="text-xl text-gray-200 max-w-3xl mx-auto">
              Transparência e segurança no tratamento dos seus dados pessoais
            </p>
          </div>
        </section>

        <section className="py-16 bg-background">
          <div className="container mx-auto px-4 max-w-4xl">
            <Card className="p-8">
              <div className="prose prose-slate max-w-none">
                <p className="text-sm text-muted-foreground mb-4">
                  Última atualização: Janeiro de 2025
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">1. Introdução</h2>
                <p className="mb-4">
                  A Saúde Ambiental está comprometida com a privacidade e a proteção dos dados
                  pessoais de seus clientes, parceiros e visitantes. Esta Política de Privacidade
                  descreve como coletamos, usamos, armazenamos e protegemos suas informações em
                  conformidade com a Lei Geral de Proteção de Dados (LGPD - Lei nº 13.709/2018).
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">2. Dados Coletados</h2>
                <p className="mb-4">Coletamos os seguintes tipos de dados:</p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>
                    <strong>Dados de Identificação:</strong> nome completo, CPF/CNPJ, endereço
                  </li>
                  <li>
                    <strong>Dados de Contato:</strong> e-mail, telefone, WhatsApp
                  </li>
                  <li>
                    <strong>Dados de Serviços:</strong> histórico de contratações, certificados,
                    relatórios técnicos
                  </li>
                  <li>
                    <strong>Dados de Navegação:</strong> endereço IP, cookies, páginas visitadas
                  </li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">3. Finalidade do Uso</h2>
                <p className="mb-4">Utilizamos seus dados para:</p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Prestação dos serviços contratados</li>
                  <li>Emissão de certificados e laudos técnicos</li>
                  <li>Comunicação sobre serviços e atendimento</li>
                  <li>Cumprimento de obrigações legais e regulatórias</li>
                  <li>Melhoria dos nossos serviços</li>
                  <li>Envio de informações promocionais (com seu consentimento)</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">4. Compartilhamento de Dados</h2>
                <p className="mb-4">
                  Seus dados podem ser compartilhados apenas com:
                </p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Órgãos fiscalizadores (ADAGRO, IBAMA, Vigilância Sanitária, etc.)</li>
                  <li>Prestadores de serviços essenciais (hospedagem, e-mail, pagamento)</li>
                  <li>Autoridades judiciais, quando legalmente exigido</li>
                </ul>
                <p className="mb-4">
                  <strong>Jamais vendemos ou compartilhamos seus dados com terceiros para fins
                  comerciais.</strong>
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">5. Segurança</h2>
                <p className="mb-4">
                  Adotamos medidas técnicas e administrativas para proteger seus dados contra
                  acessos não autorizados, perda, alteração ou destruição. Isso inclui:
                </p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Criptografia de dados sensíveis</li>
                  <li>Controle de acesso restrito</li>
                  <li>Monitoramento contínuo de segurança</li>
                  <li>Treinamento da equipe em proteção de dados</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">6. Seus Direitos</h2>
                <p className="mb-4">Conforme a LGPD, você tem direito a:</p>
                <ul className="list-disc pl-6 mb-4 space-y-2">
                  <li>Confirmar a existência de tratamento de dados</li>
                  <li>Acessar seus dados pessoais</li>
                  <li>Corrigir dados incompletos ou desatualizados</li>
                  <li>Solicitar anonimização ou eliminação de dados</li>
                  <li>Revogar consentimento</li>
                  <li>Obter portabilidade dos dados</li>
                </ul>

                <h2 className="text-2xl font-bold mb-4 mt-8">7. Cookies</h2>
                <p className="mb-4">
                  Utilizamos cookies para melhorar sua experiência de navegação. Você pode gerenciar
                  as preferências de cookies nas configurações do seu navegador.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">8. Retenção de Dados</h2>
                <p className="mb-4">
                  Mantemos seus dados pelo período necessário para cumprir as finalidades descritas,
                  respeitando os prazos legais de guarda de documentos fiscais e técnicos.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">9. Alterações</h2>
                <p className="mb-4">
                  Esta política pode ser atualizada periodicamente. Recomendamos que você a revise
                  regularmente.
                </p>

                <h2 className="text-2xl font-bold mb-4 mt-8">10. Contato</h2>
                <p className="mb-4">
                  Para exercer seus direitos ou esclarecer dúvidas sobre privacidade:
                </p>
                <ul className="list-none mb-4 space-y-2">
                  <li>
                    <strong>E-mail:</strong> privacidade@saudeambiental.com.br
                  </li>
                  <li>
                    <strong>Telefone:</strong> (81) 3000-1234
                  </li>
                  <li>
                    <strong>Endereço:</strong> Av. Principal, 1234 - Centro, Recife/PE
                  </li>
                </ul>
              </div>
            </Card>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default PoliticaPrivacidade;
