import Header from "@/components/layout/Header";
import Footer from "@/components/layout/Footer";
import { Card } from "@/components/ui/card";
import { Target, Eye, Award, Users, Shield, FileCheck } from "lucide-react";

const QuemSomos = () => {
  return (
    <div className="min-h-screen">
      <Header />
      <main>
        {/* Hero Section */}
        <section className="py-20 bg-gradient-to-br from-secondary to-secondary/80 text-white">
          <div className="container mx-auto px-4">
            <div className="max-w-3xl">
              <h1 className="mb-6">Sobre Nós</h1>
              <p className="text-xl text-gray-200">
                Especialistas em saúde ambiental, oferecendo soluções profissionais em controle de
                pragas e higienização há mais de 15 anos.
              </p>
            </div>
          </div>
        </section>

        {/* História */}
        <section className="py-16 bg-background">
          <div className="container mx-auto px-4">
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <h2 className="mb-6">Nossa História</h2>
                <p className="text-muted-foreground mb-4">
                  Fundada em 2008, a Saúde Ambiental nasceu com o propósito de oferecer serviços de
                  controle de pragas e higienização com excelência técnica e total conformidade com
                  as normas regulamentadoras.
                </p>
                <p className="text-muted-foreground mb-4">
                  Ao longo dos anos, construímos uma reputação sólida baseada em profissionalismo,
                  pontualidade e resultados comprovados. Nossa equipe é formada por profissionais
                  altamente qualificados, com responsável técnico registrado no CRMV.
                </p>
                <p className="text-muted-foreground">
                  Hoje, atendemos mais de 5.000 clientes em diversos segmentos: condomínios,
                  comércios, indústrias, hospitais e residências, sempre com o compromisso de
                  proteger ambientes e garantir a segurança de todos.
                </p>
              </div>
              <div className="grid grid-cols-2 gap-4">
                <Card className="p-6 text-center">
                  <div className="text-4xl font-bold text-primary mb-2">15+</div>
                  <p className="text-sm text-muted-foreground">Anos de Experiência</p>
                </Card>
                <Card className="p-6 text-center">
                  <div className="text-4xl font-bold text-primary mb-2">5000+</div>
                  <p className="text-sm text-muted-foreground">Clientes Atendidos</p>
                </Card>
                <Card className="p-6 text-center">
                  <div className="text-4xl font-bold text-primary mb-2">98%</div>
                  <p className="text-sm text-muted-foreground">Satisfação</p>
                </Card>
                <Card className="p-6 text-center">
                  <div className="text-4xl font-bold text-primary mb-2">24/7</div>
                  <p className="text-sm text-muted-foreground">Atendimento</p>
                </Card>
              </div>
            </div>
          </div>
        </section>

        {/* Público-alvo e Proposta */}
        <section className="py-16 bg-background">
          <div className="container mx-auto px-4">
            <div className="text-center mb-12">
              <h2 className="mb-4">Público-alvo e Proposta</h2>
              <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
                Atendemos diferentes segmentos com soluções completas e atenção total ao cliente.
              </p>
            </div>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              <Card className="p-6">
                <h3 className="text-xl font-bold mb-3">Quem atendemos</h3>
                <p className="text-muted-foreground">
                  Residências, empresas, indústrias, hospitais, escolas, shopping e outros segmentos.
                </p>
              </Card>
              <Card className="p-6">
                <h3 className="text-xl font-bold mb-3">O que resolvemos</h3>
                <p className="text-muted-foreground">
                  Infestações de pragas com controle eficiente e manutenção preventiva do ambiente.
                </p>
              </Card>
              <Card className="p-6">
                <h3 className="text-xl font-bold mb-3">Diferencial ATC</h3>
                <p className="text-muted-foreground">
                  Atendimento com ATC (Atenção Total ao Cliente) do primeiro contato ao pós-serviço.
                </p>
              </Card>
            </div>
          </div>
        </section>

        {/* Missão, Visão e Valores */}
        <section className="py-16 bg-muted">
          <div className="container mx-auto px-4">
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              <Card className="p-8">
                <Target className="w-12 h-12 text-primary mb-4" />
                <h3 className="text-2xl font-bold mb-4">Missão</h3>
                <p className="text-muted-foreground">
                  Proteger ambientes e promover saúde através de serviços especializados em controle
                  de pragas e higienização, com excelência técnica, segurança e respeito ao meio
                  ambiente.
                </p>
              </Card>
              <Card className="p-8">
                <Eye className="w-12 h-12 text-primary mb-4" />
                <h3 className="text-2xl font-bold mb-4">Visão</h3>
                <p className="text-muted-foreground">
                  Ser referência nacional em saúde ambiental, reconhecida pela qualidade dos
                  serviços, inovação tecnológica e compromisso com a satisfação dos clientes.
                </p>
              </Card>
              <Card className="p-8">
                <Award className="w-12 h-12 text-primary mb-4" />
                <h3 className="text-2xl font-bold mb-4">Valores</h3>
                <ul className="text-muted-foreground space-y-2">
                  <li>• Ética e Transparência</li>
                  <li>• Qualidade e Excelência</li>
                  <li>• Segurança e Responsabilidade</li>
                  <li>• Respeito ao Cliente</li>
                  <li>• Compromisso Ambiental</li>
                </ul>
              </Card>
            </div>
          </div>
        </section>

        {/* Equipe Técnica */}
        <section className="py-16 bg-background">
          <div className="container mx-auto px-4">
            <div className="text-center mb-12">
              <h2 className="mb-4">Equipe Técnica Especializada</h2>
              <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
                Profissionais qualificados e certificados para garantir a excelência em cada serviço.
              </p>
            </div>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              <Card className="p-6">
                <Users className="w-10 h-10 text-primary mb-4" />
                <h3 className="text-xl font-bold mb-3">Técnicos Certificados</h3>
                <p className="text-muted-foreground">
                  Equipe treinada periodicamente, com conhecimento atualizado em técnicas e produtos.
                </p>
              </Card>
              <Card className="p-6">
                <Shield className="w-10 h-10 text-primary mb-4" />
                <h3 className="text-xl font-bold mb-3">Responsável Técnico</h3>
                <p className="text-muted-foreground">
                  Médico Veterinário registrado no CRMV, garantindo conformidade técnica e legal.
                </p>
              </Card>
              <Card className="p-6">
                <FileCheck className="w-10 h-10 text-primary mb-4" />
                <h3 className="text-xl font-bold mb-3">Documentação</h3>
                <p className="text-muted-foreground">
                  Emissão de laudos técnicos, certificados e toda documentação exigida.
                </p>
              </Card>
            </div>
          </div>
        </section>

        {/* Licença Operacional */}
        <section className="py-16 bg-primary text-primary-foreground">
          <div className="container mx-auto px-4 text-center">
            <FileCheck className="w-16 h-16 mx-auto mb-6" />
            <h2 className="mb-4 text-white">Licença Operacional</h2>
            <p className="text-xl text-white/90 max-w-3xl mx-auto mb-6">
              Operamos com todas as licenças e certificações exigidas pelos órgãos reguladores,
              incluindo ADAGRO, IBAMA, Vigilância Sanitária, DIRCON, SEMAN, CPRH, ANVISA, CRQ, NR-31, NR-33 e NR-35.
            </p>
            <div className="flex flex-wrap justify-center gap-4 text-sm text-white/80">
              <span>Licença ADAGRO nº 12345</span>
              <span>•</span>
              <span>Cadastro IBAMA nº 67890</span>
            </div>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default QuemSomos;
