import Header from "@/components/layout/Header";
import Footer from "@/components/layout/Footer";
import { Button } from "@/components/ui/button";
import { Card } from "@/components/ui/card";
import { Accordion, AccordionContent, AccordionItem, AccordionTrigger } from "@/components/ui/accordion";
import { Bug, Droplets, Sparkles, Check, Phone, MessageCircle } from "lucide-react";
import desinsetizacaoImg from "@/assets/service-desinsetizacao.jpg";
import limpezaImg from "@/assets/service-limpeza.jpg";
import sanitizacaoImg from "@/assets/service-sanitizacao.jpg";
import { company } from "@/config/company";

const services = [
  {
    id: "desinsetizacao",
    title: "Desinsetização",
    icon: Bug,
    image: desinsetizacaoImg,
    description: "Controle eficaz de pragas urbanas com produtos certificados e métodos seguros.",
    fullDescription:
      "Nosso serviço de desinsetização elimina pragas como baratas, formigas, mosquitos, pulgas e outros insetos. Utilizamos produtos de última geração, registrados na ANVISA e aplicados por técnicos treinados.",
    scope: [
      "Inspeção técnica detalhada do ambiente",
      "Identificação das espécies e pontos críticos",
      "Aplicação de inseticidas certificados",
      "Vedação de frestas e pontos de entrada",
      "Orientações de prevenção",
      "Relatório técnico completo",
    ],
    frequency: "Recomendamos aplicação trimestral ou conforme necessidade",
    faqs: [
      {
        question: "Os produtos são seguros para crianças e pets?",
        answer:
          "Sim, utilizamos apenas produtos com baixa toxicidade para humanos e animais, todos registrados na ANVISA. Após a aplicação, recomendamos aguardar o tempo de carência indicado.",
      },
      {
        question: "Qual a garantia do serviço?",
        answer:
          "Oferecemos garantia de 3 meses. Caso haja reincidência, realizamos reaplicação gratuita.",
      },
      {
        question: "É necessário sair de casa durante a aplicação?",
        answer:
          "Recomendamos que pessoas e animais permaneçam fora do ambiente por 4 horas após a aplicação.",
      },
    ],
  },
  {
    id: "limpeza",
    title: "Limpeza de Reservatórios",
    icon: Droplets,
    image: limpezaImg,
    description: "Higienização completa de caixas d'água conforme normas da Vigilância Sanitária.",
    fullDescription:
      "Realizamos limpeza e desinfecção de reservatórios de água potável seguindo rigorosamente as normas da Vigilância Sanitária e portarias do Ministério da Saúde.",
    scope: [
      "Esvaziamento controlado do reservatório",
      "Remoção de sedimentos e impurezas",
      "Escovação e lavagem das paredes e fundo",
      "Desinfecção com produtos certificados",
      "Enxágue e verificação de qualidade",
      "Emissão de laudo técnico",
    ],
    frequency: "Obrigatório a cada 6 meses conforme legislação",
    faqs: [
      {
        question: "Quanto tempo leva o serviço?",
        answer:
          "Em média, de 2 a 4 horas dependendo do tamanho do reservatório e condições de acesso.",
      },
      {
        question: "Preciso fornecer água durante o serviço?",
        answer:
          "Sim, é necessário ponto de água próximo para a execução da limpeza.",
      },
      {
        question: "Quando posso usar a água após a limpeza?",
        answer:
          "A água pode ser utilizada imediatamente após o término do serviço e enchimento do reservatório.",
      },
    ],
  },
  {
    id: "sanitizacao",
    title: "Sanitização",
    icon: Sparkles,
    image: sanitizacaoImg,
    description: "Desinfecção profissional de ambientes com produtos de alta eficácia.",
    fullDescription:
      "A sanitização é um processo de desinfecção que elimina 99,9% de vírus, bactérias e fungos presentes em superfícies e ambientes.",
    scope: [
      "Avaliação do ambiente e pontos críticos",
      "Proteção de equipamentos sensíveis",
      "Aplicação de sanitizante por nebulização",
      "Desinfecção de superfícies de contato",
      "Tempo de ação conforme protocolo",
      "Certificado de sanitização",
    ],
    frequency: "Conforme necessidade ou protocolos sanitários",
    faqs: [
      {
        question: "Qual a diferença entre sanitização e limpeza?",
        answer:
          "A limpeza remove sujidades visíveis. A sanitização elimina microrganismos invisíveis através de produtos desinfetantes específicos.",
      },
      {
        question: "Quanto tempo dura o efeito?",
        answer:
          "O efeito imediato é instantâneo. Para manutenção, recomendamos aplicações periódicas conforme fluxo de pessoas no ambiente.",
      },
      {
        question: "Deixa odor ou resíduo?",
        answer:
          "Não. Utilizamos produtos que não deixam odores fortes nem resíduos após a secagem.",
      },
    ],
  },
];

const Servicos = () => {
  const whatsappNumber = company.whatsapps.vendas.replace(/\D/g, "");
  const centralPhone = company.telefones[0];

  return (
    <div className="min-h-screen">
      <Header />
      <main>
        {/* Hero */}
        <section className="py-20 bg-gradient-to-br from-secondary to-secondary/80 text-white">
          <div className="container mx-auto px-4 text-center">
            <h1 className="mb-6">Nossos Serviços</h1>
            <p className="text-xl text-gray-200 max-w-3xl mx-auto">
              Soluções completas em saúde ambiental com certificações técnicas e conformidade total.
            </p>
          </div>
        </section>

        {/* Informações Operacionais */}
        <section className="py-16 bg-background">
          <div className="container mx-auto px-4">
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
              <Card className="p-6 text-center">
                <h3 className="font-bold mb-2">Garantia de 3 meses</h3>
                <p className="text-sm text-muted-foreground">
                  Garantia por escrito com retorno gratuito se o problema persistir.
                </p>
              </Card>
              <Card className="p-6 text-center">
                <h3 className="font-bold mb-2">Cobertura geográfica</h3>
                <p className="text-sm text-muted-foreground">
                  Cobrimos toda a região Nordeste.
                </p>
              </Card>
              <Card className="p-6 text-center">
                <h3 className="font-bold mb-2">Entrega de serviço</h3>
                <p className="text-sm text-muted-foreground">
                  Entregamos serviço e não produto, com laudos e registros técnicos.
                </p>
              </Card>
            </div>

            <div className="max-w-3xl mx-auto text-center">
              <h2 className="mb-4">Como solicitar orçamento</h2>
              <p className="text-lg text-muted-foreground mb-6">
                Orçamentos direto com o telefone de vendas ou WhatsApp.
              </p>
              <div className="flex flex-col sm:flex-row justify-center gap-4">
                <Button variant="outline" size="lg" asChild>
                  <a href={`tel:${centralPhone.replace(/\s/g, "")}`}>
                    <Phone className="w-5 h-5" />
                    Telefone Central
                  </a>
                </Button>
                <Button variant="whatsapp" size="lg" asChild>
                  <a
                    href={`https://wa.me/${whatsappNumber}?text=Olá!%20Gostaria%20de%20um%20orçamento.`}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <MessageCircle className="w-5 h-5" />
                    WhatsApp Vendas
                  </a>
                </Button>
              </div>
            </div>
          </div>
        </section>

        {/* Serviços Detalhados */}
        {services.map((service) => (
          <section key={service.id} id={service.id} className="py-16 odd:bg-background even:bg-muted">
            <div className="container mx-auto px-4">
              <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div className={service.id === "limpeza" ? "lg:order-2" : ""}>
                  <div className="flex items-center space-x-4 mb-6">
                    <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center">
                      <service.icon className="w-8 h-8 text-primary" />
                    </div>
                    <h2>{service.title}</h2>
                  </div>
                  <p className="text-lg text-muted-foreground mb-6">{service.fullDescription}</p>

                  <h3 className="text-xl font-bold mb-4">Escopo do Serviço:</h3>
                  <ul className="space-y-2 mb-6">
                    {service.scope.map((item) => (
                      <li key={item} className="flex items-start space-x-2">
                        <Check className="w-5 h-5 text-primary flex-shrink-0 mt-0.5" />
                        <span className="text-muted-foreground">{item}</span>
                      </li>
                    ))}
                  </ul>

                  <Card className="p-4 bg-primary/5 border-primary/20 mb-6">
                    <p className="text-sm">
                      <strong>Periodicidade:</strong> {service.frequency}
                    </p>
                  </Card>

                  <Button
                    variant="hero"
                    size="lg"
                    asChild
                  >
                    <a
                      href={`https://wa.me/${whatsappNumber}?text=Olá!%20Gostaria%20de%20um%20orçamento%20para%20${service.title}.`}
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <Phone className="w-5 h-5" />
                      Solicitar Orçamento
                    </a>
                  </Button>
                </div>

                <div className={service.id === "limpeza" ? "lg:order-1" : ""}>
                  <img
                    src={service.image}
                    alt={service.title}
                    className="rounded-lg shadow-xl w-full"
                  />
                </div>
              </div>

              {/* FAQs */}
              <div className="mt-12 max-w-3xl mx-auto">
                <h3 className="text-2xl font-bold mb-6 text-center">Perguntas Frequentes</h3>
                <Accordion type="single" collapsible>
                  {service.faqs.map((faq, index) => (
                    <AccordionItem key={index} value={`item-${index}`}>
                      <AccordionTrigger>{faq.question}</AccordionTrigger>
                      <AccordionContent>{faq.answer}</AccordionContent>
                    </AccordionItem>
                  ))}
                </Accordion>
              </div>
            </div>
          </section>
        ))}

        {/* CTA Final */}
        <section className="py-20 bg-primary text-primary-foreground">
          <div className="container mx-auto px-4 text-center">
            <h2 className="mb-6 text-white">Pronto para Proteger seu Ambiente?</h2>
            <p className="text-xl text-white/90 mb-8 max-w-2xl mx-auto">
              Entre em contato agora e receba um orçamento personalizado sem compromisso.
            </p>
            <Button variant="outline" size="xl" asChild className="bg-white text-primary hover:bg-gray-100">
              <a
                href={`https://wa.me/${whatsappNumber}?text=Olá!%20Gostaria%20de%20solicitar%20um%20orçamento.`}
                target="_blank"
                rel="noopener noreferrer"
              >
                <Phone className="w-5 h-5" />
                Falar com Especialista
              </a>
            </Button>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default Servicos;
